<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Users extends CheckAction{

	public function action_index(){
        $users = ORM::factory('User')->find_all();

        if(Arr::get($this->request->post(), 'check')){
            foreach ($this->request->post('check') as $id){
                $user = ORM::factory('User', $id);
                $user->remove('roles');
                foreach($user->logs->find_all() as $record) {
                    $record->delete();
                }
                foreach($user->lastlogins->find_all() as $record) {
                    $record->delete();
                }

                $user->delete();
            }
            DB::delete('logpost_mini')->where('user_id', 'IN', $this->request->post('check'))->execute();
            DB::delete('logs')->where('user_id', 'IN', $this->request->post('check'))->execute();
            HTTP::redirect('/users/');
        }

        $this->template->content = BladeView::factory('users/index')
            ->bind('users', $users);
	}

    public function action_editor(){
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);

        $roles = ORM::factory('Role')->find_all();
        $user_roles = [];
        foreach($user->roles->find_all() as $role){
            if($role->id != 1) {
                $user_roles[] = $role->id;
            }
        }
        $user_roles = json_encode($user_roles, JSON_NUMERIC_CHECK);
        $reset = ((Helper::checkActionInRole('Reset password Self') && $user->id == Auth::instance()->get_user()->id) || Helper::checkActionInRole('Reset password All')) ? true : false;

        $this->template->content = BladeView::factory('users/editor')
            ->bind('user', $user)
            ->bind('roles', $roles)
            ->bind('reset', $reset)
            ->bind('user_roles', $user_roles);
    }

    public function action_reset_password()
    {
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);
        if ( ! $user->loaded()) {
            throw HTTP_Exception::factory(404);
        }

        $isSelf = Auth::instance()->get_user()->id == $user_id;
        if ($isSelf && Auth::instance()->get_user()->hasAction('Reset password Self')) {
        } elseif(Auth::instance()->get_user()->hasAction('Reset password All')) {
        } else {
            throw HTTP_Exception::factory(403);
        }

        if ( Request::POST == $this->request->method() && null !== $this->request->post('reset') )
        {
            if ( $user->setNewPassword($this->request->post(), $isSelf) )
            {
                if ( ! $isSelf )
                {
                    HTTP::redirect('/users/editor/' . $user_id);
                }
                else
                {
                    Auth::instance()->logout(true, true);
                    HTTP::redirect('/login');
                }
            }

            $errors = $user->getErrors();
        }

        $this->template->content = View::factory('users/v_reset_password')
            ->bind('user', $user)
            ->bind('isSelf', $isSelf)
            ->bind('errors', $errors)
            ->set('post', $this->request->post());
    }

    public function action_edit_net_access(){
        if(!Helper::checkActionInRole('Edit user net list')){
            throw HTTP_Exception::factory(404);
        }
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);
        if ( ! $user->loaded()) {
            throw HTTP_Exception::factory(404);
        }

        $file_path = Kohana::find_file('net_access', $user_id, 'json');
        $nets = ORM::factory('Cache_Net')
            ->find_all()
            ->as_array(null, 'name');
        if ( 0 == count($nets) )
        {
            $nets = DB::select('net')
                ->from('clients')
                ->distinct(true)
                ->execute()
                ->as_array(null, 'net');
            if ( count($nets) > 0 )
            {
                Kohana::$log->add(Log::ERROR, 'Cache_nets don\'t work');
            }
        }

        if(isset($_POST['update'])){
            if(isset($_POST['group'])){
                file_put_contents(
                    APPPATH.'net_access/'.$user_id.'.json',
                    json_encode($_POST['group'])
                );
            }else{
                if(file_exists(APPPATH.'net_access/'.$user_id.'.json'))
                    unlink(APPPATH.'net_access/'.$user_id.'.json');
            }
            HTTP::redirect('/users');
        }

        $file = null;
        if($file_path){
            $file = json_decode(
                file_get_contents($file_path)
            );

            foreach($file as $f){
                if(!array_search($f, $nets)){
                    $nets[] = $f;
                }
            }
        }

        $nets = array_combine($nets, $nets);

        $this->template->content = BladeView::factory('users/net')
            ->bind('user', $user)
            ->bind('nets', $nets)
            ->bind('file', $file);
    }

    public function action_edit_country_access(){
        if(!Helper::checkActionInRole('Edit user country list')){
            throw HTTP_Exception::factory(404);
        }
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);
        if ( ! $user->loaded()) {
            throw HTTP_Exception::factory(404);
        }

        $file_path = Kohana::find_file('country_access', $user_id, 'json');
        $model = Kohana::$config->load('locations')->as_array();

        if(isset($_POST['update'])){
            if(isset($_POST['country'])){
                file_put_contents(
                    APPPATH.'country_access/'.$user_id.'.json',
                    json_encode($_POST['country'])
                );
            }else{
                if(file_exists(APPPATH.'country_access/'.$user_id.'.json'))
                    unlink(APPPATH.'country_access/'.$user_id.'.json');
            }
            HTTP::redirect('/users');
        }

        $file = null;
        if($file_path){
            $file = json_decode(
                file_get_contents($file_path)
            );

            foreach($file as $f){
                if(!array_search($f, $model)){
                    $model[] = $f;
                }
            }
        }

        $model = array_combine($model, $model);

        $this->template->content = BladeView::factory('users/country')
            ->bind('user', $user)
            ->bind('country', $model)
            ->bind('file', $file);
    }
    
    public function action_view_user_queries()
    {
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);
        
        $user_queries = $user->queries->find_all();
        
        $this->template->content = View::factory('users/v_view_user_queries')
            ->bind('user', $user)
            ->bind('user_queries', $user_queries);
    }
    
    public function action_activesessions()
    {
        if ( ! Helper::checkActionInRole('ActiveSessionsAndLastLogins')) {
            throw HTTP_Exception::factory(403);
        }
        
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);
        $user_sessions = $user
            ->sessions
            ->scopeNotExpired()
            ->find_all()
            ->as_array();
        $user_tokens = $user
            ->user_tokens
            ->find_all()
            ->as_array();
        
        $activesessions = array_merge($user_sessions, $user_tokens);
        usort($activesessions, function($a, $b) {
            if ($a instanceof Model_Session) {
                $aTime = $a->last_active;
            } else {
                $aTime = $a->created;
            }
            if ($b instanceof Model_Session) {
                $bTime = $b->last_active;
            } else {
                $bTime = $b->created;
            }

            return $aTime == $bTime ? 0 : ($aTime < $bTime ? 1 : -1);
        });
        
        $this->template->content = View::factory('users/v_activesessions')
            ->bind('activesessions', $activesessions);
    }

    public function action_lastlogins()
    {
        if ( ! Helper::checkActionInRole('ActiveSessionsAndLastLogins')) {
            throw HTTP_Exception::factory(403);
        }
        
        $user_id = $this->request->param('id');
        $user = ORM::factory('User', $user_id);
        $user_lastlogins = $user
            ->lastlogins
            ->order_by('user_lastlogin.logged_at', 'DESC')
            ->find_all();
        
        $this->template->content = View::factory('users/v_lastlogins')
            ->bind('user_lastlogins', $user_lastlogins);
    }
    
}